package ru.yandex.travel.orders.workflows.orderitem.bronevik;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.hotels.common.partners.bronevik.DefaultBronevikClient;

@Configuration
@EnableConfigurationProperties(BronevikProperties.class)
@Slf4j
public class BronevikConfiguration {
    @Bean
    public BronevikClient bronevikClient(BronevikProperties properties, Retry retryHelper) {
        return new DefaultBronevikClient(properties.getClient(), log, retryHelper);
    }
}
