package ru.yandex.travel.orders.workflows.orderitem.bronevik;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.entities.FiscalItem;
import ru.yandex.travel.orders.entities.FiscalItemType;
import ru.yandex.travel.orders.grpc.helpers.OrderProtoUtils;
import ru.yandex.travel.orders.workflows.orderitem.hotel.AbstractHotelFiscalItemCreator;

@RequiredArgsConstructor
@Service
public class BronevikFiscalItemCreator extends AbstractHotelFiscalItemCreator<BronevikOrderItem> {
    @Autowired
    private BronevikProperties properties;

    @Override
    protected void addProviderSpecificPropertiesToMainFiscalItem(FiscalItem item, BronevikOrderItem orderItem) {
        item.setType(FiscalItemType.EXPEDIA_HOTEL);
        item.setTitle(properties.getBilling().getFiscalTitle());
        item.setVatType(OrderProtoUtils.fromEVat(properties.getBilling().getFiscalVat()));
    }
}
