package ru.yandex.travel.orders.workflows.orderitem.bronevik;

import java.math.BigDecimal;
import java.time.Duration;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClientProperties;
import ru.yandex.travel.orders.commons.proto.EVat;

@ConfigurationProperties(value = "bronevik", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class BronevikProperties {
    @NotNull
    @Valid
    private BronevikClientProperties client;
    @Valid
    private Billing billing;
    @Valid
    private Duration orderExpiredAfter;

    @Getter
    @Setter
    public static class Billing {
        @NotNull
        private Long clientId;
        @NotNull
        private Long contractId;
        @NotNull
        private BigDecimal confirmRate;
        @NotEmpty
        private String fiscalTitle;
        @NotNull
        private EVat fiscalVat;
    }
}
