package ru.yandex.travel.orders.workflows.orderitem.bronevik;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.CancellingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.CheckedOfferStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.CheckingOfferStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.ConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.ConfirmingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers.RefundingStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class BronevikWorkflowConfiguration {
    private final BronevikClient bronevikClient;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final BillingPartnerService billingPartnerService;
    private final BronevikFiscalItemCreator fiscalItemCreator;
    private final BronevikProperties bronevikProperties;
    private final Meters meters;

    @Bean
    public WorkflowEventHandler<BronevikOrderItem> bronevikOrderItemWorkflowEventHandler() {
        ImmutableMap.Builder<EBronevikItemState, StatefulWorkflowEventHandler<EBronevikItemState,
                BronevikOrderItem>> builder = ImmutableMap.builder();
        builder
                .put(EBronevikItemState.IS_NEW, new NewStateHandler(meters, bronevikClient, billingPartnerService))
                .put(EBronevikItemState.IS_CHECKING_OFFER, new CheckingOfferStateHandler(meters, bronevikClient,
                        bronevikProperties, fiscalItemCreator))
                .put(EBronevikItemState.IS_CHECKED_OFFER, new CheckedOfferStateHandler(meters, bronevikClient))
                .put(EBronevikItemState.IS_CANCELLING, new CancellingStateHandler(meters, bronevikClient))
                .put(EBronevikItemState.IS_CANCELLED, new CancelledStateHandler(meters, bronevikClient))
                .put(EBronevikItemState.IS_CONFIRMING, new ConfirmingStateHandler(meters, bronevikClient))
                .put(EBronevikItemState.IS_CONFIRMED, new ConfirmedStateHandler(meters, bronevikClient))
                .put(EBronevikItemState.IS_REFUNDING, new RefundingStateHandler(meters, bronevikClient));

        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
