package ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.orders.BronevikHotelItinerary;
import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.hotels.common.partners.bronevik.model.OrderStatus;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.TCancellationCommit;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class CancellingStateHandler extends BaseBronevikHandler {
    public CancellingStateHandler(Meters meters, BronevikClient bronevikClient) {
        super(meters, bronevikClient);
    }

    @HandleEvent
    public void cancelOrder(TCancellationCommit message,
                            StateContext<EBronevikItemState, BronevikOrderItem> context) {
        BronevikHotelItinerary itinerary = context.getWorkflowEntity().getItinerary();

        OrderStatus cancelledOrderStatus = cancelOrderWithStatusCheck(itinerary, getCallContext(context, CallContext.CallPhase.ORDER_CANCELLATION));

        if (cancelledOrderStatus == OrderStatus.CANCELLED_WITH_PENALTY) {
            log.warn("Order was cancelled with penalty");
        }

        toCancelledStatus(context);
    }
}
