package ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers;

import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;

import ru.yandex.travel.hotels.common.orders.CancellationDetails;
import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.TConfirmationCommit;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.TReservationExpired;
import ru.yandex.travel.orders.workflow.hotels.proto.TCancellationStart;
import ru.yandex.travel.orders.workflow.hotels.proto.TConfirmationStart;
import ru.yandex.travel.orders.workflow.order.proto.TServiceCancelled;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class CheckedOfferStateHandler extends BaseBronevikHandler {

    public CheckedOfferStateHandler(Meters meters, BronevikClient bronevikClient) {
        super(meters, bronevikClient);
    }

    @HandleEvent
    public void startCancellation(TCancellationStart message,
                                  StateContext<EBronevikItemState, BronevikOrderItem> context) {
        context.setState(EBronevikItemState.IS_CANCELLED);
        context.scheduleExternalEvent(context.getWorkflowEntity().getOrderWorkflowId(),
                TServiceCancelled.newBuilder().setServiceId(context.getWorkflowEntity().getId().toString()).build());
        if (Strings.isNotEmpty(message.getReason())) {
            var itinerary = context.getWorkflowEntity().getItinerary();
            itinerary.setOrderCancellationDetails(CancellationDetails.create(message.getReason()));
            meters.incrementCancellationCounter(EPartnerId.PI_BRONEVIK, message.getReason());
        }
        log.info("CANCELLED");
    }

    @HandleEvent
    public void startGenericCancellation(ru.yandex.travel.orders.workflow.orderitem.generic.proto.TCancellationStart message,
                                         StateContext<EBronevikItemState, BronevikOrderItem> context) {
        startCancellation(TCancellationStart.newBuilder().build(), context);
    }

    @HandleEvent
    public void handleReservationExpired(TReservationExpired message,
                                         StateContext<EBronevikItemState, BronevikOrderItem> context) {
        context.setState(EBronevikItemState.IS_CANCELLED);
        context.scheduleExternalEvent(context.getWorkflowEntity().getOrderWorkflowId(),
                TServiceCancelled.newBuilder().setServiceId(context.getWorkflowEntity().getId().toString()).build());
        log.info("CANCELLED");
        var itinerary = context.getWorkflowEntity().getItinerary();
        var reason = CancellationDetails.Reason.MONEY_ACQUIRE_ERROR;
        itinerary.setOrderCancellationDetails(CancellationDetails.create(reason));
        meters.incrementCancellationCounter(EPartnerId.PI_BRONEVIK, reason);
    }

    @HandleEvent
    public void startConfirmation(TConfirmationStart message,
                                  StateContext<EBronevikItemState, BronevikOrderItem> context) {
        startGenericConfirmation(null, context);
    }

    @HandleEvent
    public void startGenericConfirmation(ru.yandex.travel.orders.workflow.orderitem.generic.proto.TConfirmationStart message,
                                         StateContext<EBronevikItemState, BronevikOrderItem> context) {
        context.setState(EBronevikItemState.IS_CONFIRMING);
        context.scheduleEvent(TConfirmationCommit.newBuilder().build());
        log.info("Scheduled order creation");
    }
}
