package ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers;

import java.time.Instant;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.orders.BronevikHotelItinerary;
import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.TCheckOfferCommit;
import ru.yandex.travel.orders.workflow.order.proto.TServiceReserved;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.BronevikFiscalItemCreator;
import ru.yandex.travel.orders.workflows.orderitem.bronevik.BronevikProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class CheckingOfferStateHandler extends BaseBronevikHandler {
    private BronevikProperties bronevikProperties;
    private BronevikFiscalItemCreator fiscalItemCreator;

    public CheckingOfferStateHandler(Meters meters, BronevikClient bronevikClient, BronevikProperties bronevikProperties,
                                     BronevikFiscalItemCreator fiscalItemCreator) {
        super(meters, bronevikClient);
        this.bronevikProperties = bronevikProperties;
        this.fiscalItemCreator = fiscalItemCreator;
    }

    @HandleEvent
    public void checkOffer(TCheckOfferCommit message,
                           StateContext<EBronevikItemState, BronevikOrderItem> context) {
        boolean isActualOffer = checkOfferPricing(context, getCallContext(context, CallContext.CallPhase.ORDER_RESERVATION));

        if (!isActualOffer) {
            toCancelledStatus(context);

            return;
        }

        BronevikOrderItem orderItem = context.getWorkflowEntity();
        Instant expiresAt = Instant.now().plus(bronevikProperties.getOrderExpiredAfter());
        orderItem.setExpiresAt(expiresAt);
        fiscalItemCreator.addFiscalItems(orderItem);

        BronevikHotelItinerary itinerary = context.getWorkflowEntity().getItinerary();
        itinerary.setExpiresAtInstant(expiresAt);

        context.setState(EBronevikItemState.IS_CHECKED_OFFER);
        context.scheduleExternalEvent(context.getWorkflowEntity().getOrderWorkflowId(),
                TServiceReserved.newBuilder().setServiceId(context.getWorkflowEntity().getId().toString()).build());
    }
}
