package ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.TRefundCommit;
import ru.yandex.travel.orders.workflow.hotels.proto.TRefundStart;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@IgnoreEvents(types = {TMoneyAcquired.class})
public class ConfirmedStateHandler extends BaseBronevikHandler {

    public ConfirmedStateHandler(Meters meters, BronevikClient bronevikClient) {
        super(meters, bronevikClient);
    }

    @HandleEvent
    public void handleRefundStart(TRefundStart message, StateContext<EBronevikItemState, BronevikOrderItem> context) {
        context.setState(EBronevikItemState.IS_REFUNDING);
        context.scheduleEvent(TRefundCommit.newBuilder()
                .setToken(message.getToken())
                .setForce(message.getForce())
                .setSkipFinEvents(message.getSkipFinEvents())
                .setMoneyRefundMode(message.getMoneyRefundMode())
                .setReason(message.getReason())
                .setRefundDescription(message.getRefundDescription())
                .build());
        log.info("Scheduled Refund");
    }
}
