package ru.yandex.travel.orders.workflows.orderitem.bronevik.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.TCheckOfferCommit;
import ru.yandex.travel.orders.workflow.hotels.proto.TReservationStart;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class NewStateHandler extends BaseBronevikHandler {
    private BillingPartnerService billingPartnerService;

    public NewStateHandler(Meters meters, BronevikClient bronevikClient, BillingPartnerService billingPartnerService) {
        super(meters, bronevikClient);
        this.billingPartnerService = billingPartnerService;
    }

    @HandleEvent
    public void handleRegister(TReservationStart message, StateContext<EBronevikItemState, BronevikOrderItem> context) {
        handleGenericRegister(null, context);
    }

    @HandleEvent
    public void handleGenericRegister(ru.yandex.travel.orders.workflow.orderitem.generic.proto.TReservationStart message,
                                      StateContext<EBronevikItemState, BronevikOrderItem> context) {
        // TODO(mokosha): Вернуть после подписания контракта с Броневиком. Сейчас billingId неизвестен
//        billingPartnerService.addAgreementOrThrow(context.getWorkflowEntity());
        context.setState(EBronevikItemState.IS_CHECKING_OFFER);
        context.scheduleEvent(TCheckOfferCommit.newBuilder().build());
        log.info("scheduled checking offer price and availability");
    }
}
