package ru.yandex.travel.orders.workflows.orderitem.bus;

import java.time.Duration;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.orders.commons.proto.EVat;

@Validated
@ConfigurationProperties(value = "bus", ignoreUnknownFields = false)
@Getter
@Setter
public class BusProperties {
    @NotNull
    private Long billingClientId;
    @NotNull
    private String ticketFiscalTitle;
    @NotNull
    private String partnerFeeFiscalTitle;
    @NotNull
    private String yandexFeeFiscalTitle;
    @NotNull
    private EVat yandexFeeVat;
    @NotNull
    private Integer checkExpirationTaskNumberOfItems;
    @NotNull
    private Duration checkExpirationTaskInitialStartDelay;
    @NotNull
    private Duration checkExpirationTaskPeriod;
    @NotNull
    private Duration refundCalculationExpireTime;
    @NotNull
    private NotificationProperties notification;
    @NotNull
    private Duration reservationRetryDelay;
    @Positive
    private int reservationMaxTries;
    @NotNull
    private Duration refundCommitRetryDelay;
    @Positive
    private int refundCommitMaxTries;
    @NotNull
    private Duration confirmationRetryDelay;
    @Positive
    private int confirmationMaxTries;
    @NotNull
    private Duration cancellationRetryDelay;
    @Positive
    private int cancellationMaxTries;

    @Getter
    @Setter
    @Validated
    public static class NotificationProperties {
        @NotBlank
        private String orderConfirmedCampaign;
        @NotNull
        private Duration preparingAttachmentsTime;
        @NotBlank
        private String frontUrl;
        @NotBlank
        private String orderConfirmedSmsText;
        @NotBlank
        private String orderRefundCampaign;
    }
}
