package ru.yandex.travel.orders.workflows.orderitem.bus.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.bus.model.BusReservation;
import ru.yandex.travel.orders.entities.BusOrderItem;
import ru.yandex.travel.orders.services.buses.BusPartnersService;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.orderitem.bus.proto.TReservationCommit;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TReservationStart;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@RequiredArgsConstructor
@Slf4j
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<EOrderItemState, BusOrderItem> {
    private final BillingPartnerService billingPartnerService;
    private final BusPartnersService busPartnersService;

    @HandleEvent
    public void handleRegister(TReservationStart message, StateContext<EOrderItemState, BusOrderItem> context) {
        BusReservation payload = context.getWorkflowEntity().getPayload();
        // TODO(ganintsev): maybe we should move setBusPartner() into OrdersService.createOrder()
        payload.getRide().setBusPartner(busPartnersService.getPartnerById(payload.getRide().getSupplierId()));
        billingPartnerService.addAgreementOrThrow(context.getWorkflowEntity());
        context.setState(EOrderItemState.IS_RESERVING);
        context.scheduleEvent(TReservationCommit.newBuilder().build());
    }
}
