package ru.yandex.travel.orders.workflows.orderitem.bus.handlers;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.BusOrderItem;
import ru.yandex.travel.orders.workflow.orderitem.bus.proto.TCancellationCommit;
import ru.yandex.travel.orders.workflow.orderitem.bus.proto.TConfirmationCommit;
import ru.yandex.travel.orders.workflow.orderitem.bus.proto.TReservationExpired;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TCancellationStart;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TConfirmationStart;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class ReservedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EOrderItemState, BusOrderItem> {

    @HandleEvent
    public void handleConfirmationStart(TConfirmationStart event, StateContext<EOrderItemState, BusOrderItem> ctx) {
        ctx.setState(EOrderItemState.IS_CONFIRMING);
        ctx.scheduleEvent(TConfirmationCommit.newBuilder().setDeduplicationKey(UUID.randomUUID().toString()).build());
    }

    @HandleEvent
    public void handleCancellationStart(TCancellationStart event, StateContext<EOrderItemState, BusOrderItem> ctx) {
        ctx.setState(EOrderItemState.IS_CANCELLING);
        ctx.scheduleEvent(TCancellationCommit.newBuilder().build());
    }

    @HandleEvent
    public void handleReservationExpired(TReservationExpired event, StateContext<EOrderItemState, BusOrderItem> ctx) {
        ctx.setState(EOrderItemState.IS_CANCELLING);
        ctx.scheduleEvent(TCancellationCommit.newBuilder().build());
    }
}
