package ru.yandex.travel.orders.workflows.orderitem.bus.ticketrefund;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.BusTicketRefund;
import ru.yandex.travel.orders.services.buses.BusesServiceProvider;
import ru.yandex.travel.orders.workflow.orderitem.bus.ticketrefund.proto.EBusTicketRefundState;
import ru.yandex.travel.orders.workflows.orderitem.bus.BusProperties;
import ru.yandex.travel.orders.workflows.orderitem.bus.ticketrefund.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bus.ticketrefund.handlers.RefundingStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class BusTicketRefundWorkflowConfiguration {
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final BusesServiceProvider busesServiceProvider;
    private final BusProperties busProperties;

    @Bean
    public WorkflowEventHandler<BusTicketRefund> busTicketRefundWorkflowEventHandler() {
        ImmutableMap.Builder<EBusTicketRefundState, StatefulWorkflowEventHandler<EBusTicketRefundState, BusTicketRefund>> builder = ImmutableMap.builder();
        builder
            .put(EBusTicketRefundState.RS_NEW, new NewStateHandler())
            .put(EBusTicketRefundState.RS_REFUNDING, new RefundingStateHandler(busesServiceProvider, busProperties));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
