package ru.yandex.travel.orders.workflows.orderitem.bus.ticketrefund.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.BusTicketRefund;
import ru.yandex.travel.orders.workflow.orderitem.bus.ticketrefund.proto.EBusTicketRefundState;
import ru.yandex.travel.orders.workflow.orderitem.bus.ticketrefund.proto.TRefundCommit;
import ru.yandex.travel.orders.workflow.orderitem.bus.ticketrefund.proto.TStartRefund;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class NewStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<EBusTicketRefundState, BusTicketRefund> {
    @HandleEvent
    public void handleStartRefund(TStartRefund message,
                                  StateContext<EBusTicketRefundState, BusTicketRefund> ctx) {
        ctx.setState(EBusTicketRefundState.RS_REFUNDING);
        ctx.scheduleEvent(TRefundCommit.newBuilder().build());
    }
}
