package ru.yandex.travel.orders.workflows.orderitem.dolphin;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.DolphinOrderItem;
import ru.yandex.travel.orders.entities.FiscalItem;
import ru.yandex.travel.orders.entities.FiscalItemType;
import ru.yandex.travel.orders.grpc.helpers.OrderProtoUtils;
import ru.yandex.travel.orders.workflows.orderitem.hotel.AbstractHotelFiscalItemCreator;

@Service
@RequiredArgsConstructor
public class DolphinFiscalItemCreator extends AbstractHotelFiscalItemCreator<DolphinOrderItem> {
    private final DolphinProperties dolphinProperties;

    @Override
    protected void addProviderSpecificPropertiesToMainFiscalItem(FiscalItem fiscalItem, DolphinOrderItem orderItem) {
        fiscalItem.setMoneyAmount(orderItem.getHotelItinerary().getFiscalPrice());
        fiscalItem.setType(FiscalItemType.EXPEDIA_HOTEL);  //TODO(tivelkov): create a new trust product
        fiscalItem.setTitle(dolphinProperties.getBilling().getFiscalTitle());
        fiscalItem.setInn(dolphinProperties.getBilling().getFiscalInn());
        // TODO(tivelkov): we may need to pass VAT with the itinerary as it may be hotel-specific
        fiscalItem.setVatType(OrderProtoUtils.fromEVat(dolphinProperties.getBilling().getFiscalVat()));
    }
}
