package ru.yandex.travel.orders.workflows.orderitem.dolphin;

import java.time.Duration;
import java.util.Set;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.dolphin.DolphinClientProperties;
import ru.yandex.travel.orders.commons.proto.EVat;
import ru.yandex.travel.orders.services.finances.providers.DolphinFinancialDataProviderProperties;

@ConfigurationProperties(value = "dolphin", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class DolphinProperties {
    @NotNull
    @Valid
    private DolphinClientProperties client;

    @NotNull
    @Valid
    private BillingProperties billing;

    @NotNull
    @Valid
    private DolphinFinancialDataProviderProperties financialData;

    @NotNull
    private Duration reservationDuration;

    @NotNull
    private Duration refundDuration;

    @NotNull
    private Duration pollingRetryDelay;

    @Min(0)
    private int pollingRetryAttempts;

    private Set<Long> testHotelsIds;

    private boolean enableTestNames;

    @NotNull
    private Double maxPriceMismatchThreshold;

    @Data
    @Validated
    public static class BillingProperties {
        private String fiscalTitle;
        private EVat fiscalVat;
        private String fiscalInn;
    }
}
