package ru.yandex.travel.orders.workflows.orderitem.dolphin;

import java.util.List;
import java.util.Objects;

import ru.yandex.travel.hotels.common.partners.dolphin.model.CreateOrderRequest;
import ru.yandex.travel.hotels.common.partners.dolphin.model.Guest;
import ru.yandex.travel.hotels.common.partners.dolphin.model.PriceKey;

class DolphinServiceHelper {
    public static boolean createRequestsMatch(CreateOrderRequest req1, CreateOrderRequest req2) {
        // Dolphin doesn't return the request fields as they were sent to it,
        // instead it transforms the adults, children, guests fields.
        // Also, it doesn't return the phone and email fields.
        // We have to match requests accordingly.
        return adultsAndChildrenMatch(req1, req2)
                && priceKeysMatch(req1.getPriceKey(), req2.getPriceKey())
                && guestsListsMatch(req1.getGuests(), req2.getGuests())
                ;
    }

    static boolean adultsAndChildrenMatch(CreateOrderRequest req1, CreateOrderRequest req2) {
        // we sent the exact of adults and a separate list with children ages
        // but Dolphin stores them all as adults, so we check only the total guests number
        int guests1 = req1.getAdults() + (req1.getChildren() != null ? req1.getChildren().size() : 0);
        int guests2 = req2.getAdults() + (req2.getChildren() != null ? req2.getChildren().size() : 0);
        return guests1 == guests2;
    }

    static boolean priceKeysMatch(PriceKey key1, PriceKey key2) {
        return key1.getHotelId() == key2.getHotelId()
                && key1.getTourId() == key2.getTourId()
                && key1.getPansionId() == key2.getPansionId()
                && key1.getRoomId() == key2.getRoomId()
                && key1.getRoomCategoryId() == key2.getRoomCategoryId()
                && key1.getNights() == key2.getNights()
                && Objects.equals(key1.getDate(), key2.getDate())
                // sometimes the specified bed types can change, we check only beds amount
                && ((key1.getBeds() != null ? key1.getBeds().size() : 0)
                == (key2.getBeds() != null ? key2.getBeds().size() : 0));
    }

    static boolean guestsListsMatch(List<Guest> guests1, List<Guest> guests2) {
        if (guests1 == null && guests2 == null) {
            return true;
        } else if (guests1 == null) {
            return guests2.isEmpty();
        } else if (guests2 == null) {
            return guests1.isEmpty();
        } else if (guests1.size() != guests2.size()) {
            return false;
        }
        // both are not empty and have the same length
        for (int i = 0; i < guests1.size(); i++) {
            if (!guestsMatch(guests1.get(i), guests2.get(i))) {
                return false;
            }
        }
        return true;
    }

    public static boolean guestsMatch(Guest guest1, Guest guest2) {
        // the only only info both sides (Ya.Hotels and Dolphin) always have is gender and cyrillic name
        return Objects.equals(guest1.getIsMale(), guest2.getIsMale())
                && Objects.equals(guest1.getCyrillic(), guest2.getCyrillic());
    }
}
