package ru.yandex.travel.orders.workflows.orderitem.dolphin;

import lombok.Getter;

import ru.yandex.travel.hotels.common.partners.dolphin.model.OrderState;

public class IncorrectOrderStateException extends RuntimeException {
    @Getter
    private final String code;

    @Getter
    private final OrderState state;

    public IncorrectOrderStateException(String code, OrderState state) {
        super(String.format("Dolphin order with code %s is in unexpected state %s", code, state));
        this.code = code;
        this.state = state;
    }

    public IncorrectOrderStateException(String code, OrderState state, int attempts) {
        super(String.format("Dolphin order with code %s is in unexpected state %s after %d retry attempts",
                code, state, attempts));
        this.code = code;
        this.state = state;
    }
}
