package ru.yandex.travel.orders.workflows.orderitem.expedia;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.expedia.DefaultExpediaClient;
import ru.yandex.travel.hotels.common.partners.expedia.ExpediaClient;
import ru.yandex.travel.hotels.common.partners.expedia.ExpediaClientProperties;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(ExpediaProperties.class)
public class ExpediaClientConfiguration {
    private final ExpediaProperties expediaProperties;

    @Bean
    public ExpediaClient expediaClient(@Qualifier("expediaAhcClientWrapper") AsyncHttpClientWrapper ahcClientWrapper,
                                       Retry retryHelper) {
        ExpediaClientProperties properties = new ExpediaClientProperties();
        properties.setBaseUrl(expediaProperties.getConnection().getBaseUrl());
        properties.setApiSecret(expediaProperties.getConnection().getSecret());
        properties.setApiKey(expediaProperties.getConnection().getApiKey());
        properties.setDefaultApiVersion(expediaProperties.getConnection().getDefaultApiVersion());
        properties.setHttpRequestTimeout(expediaProperties.getConnection().getHttpRequestTimeout());
        properties.setHttpReadTimeout(expediaProperties.getConnection().getHttpReadTimeout());
        properties.setEnableRetries(false);
        properties.setProfileType(expediaProperties.getConnection().getProfileType());
        return new DefaultExpediaClient(properties, ahcClientWrapper, retryHelper);
    }

}
