package ru.yandex.travel.orders.workflows.orderitem.expedia;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.ExpediaOrderItem;
import ru.yandex.travel.orders.entities.FiscalItem;
import ru.yandex.travel.orders.entities.FiscalItemType;
import ru.yandex.travel.orders.grpc.helpers.OrderProtoUtils;
import ru.yandex.travel.orders.workflows.orderitem.hotel.AbstractHotelFiscalItemCreator;

@RequiredArgsConstructor
@Service
public class ExpediaFiscalItemCreator extends AbstractHotelFiscalItemCreator<ExpediaOrderItem> {
    private final ExpediaProperties expediaProperties;

    @Override
    protected void addProviderSpecificPropertiesToMainFiscalItem(FiscalItem item, ExpediaOrderItem orderItem) {
        item.setType(FiscalItemType.EXPEDIA_HOTEL);
        item.setTitle(expediaProperties.getReservation().getBilling().getFiscalTitle());
        item.setVatType(OrderProtoUtils.fromEVat(expediaProperties.getReservation().getBilling().getFiscalVat()));
    }
}
