package ru.yandex.travel.orders.workflows.orderitem.expedia;

import java.math.BigDecimal;
import java.time.Duration;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.expedia.ApiVersion;
import ru.yandex.travel.hotels.common.partners.expedia.ProfileType;
import ru.yandex.travel.orders.commons.proto.EVat;
import ru.yandex.travel.orders.entities.VatType;

@Validated
@ConfigurationProperties(value = "expedia", ignoreUnknownFields = false)
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ExpediaProperties {
    private ConnectionProperties connection;
    private ReservationProperties reservation;
    @NotNull
    private Long billingClientId;
    @NotNull
    private Long billingContractId;
    private boolean enableTestNames;
    @NotNull
    private BigDecimal approximateFeeRate;
    private VatType vatType;

    @Getter
    @Setter
    @Validated
    public static class ReservationProperties {
        @NotNull
        private BillingProperties billing;
        @NotNull
        private String affiliatePrefix;
        @NotNull
        private Duration reservationDuration;
        @NotNull
        private Duration refundDuration;

        @Getter
        @Setter
        @Validated
        public static class BillingProperties {
            @NotEmpty
            private String addressLine;
            @NotEmpty
            private String city;
            @NotEmpty
            private String country;

            @NotEmpty
            private String fiscalProductId;
            @NotEmpty
            private String fiscalTitle;
            @NotNull
            private EVat fiscalVat;
            @NotEmpty
            private String expediaAccountId;
            @NotEmpty
            private String commissionAccountId;
            @NotNull
            @Min(0)
            @Max(1)
            private Double yandexCommissionRate;
        }
    }

    @Getter
    @Setter
    @Validated
    public static class ConnectionProperties {
        @NotEmpty
        private String apiKey;

        @NotNull
        private ApiVersion defaultApiVersion;

        @NotEmpty
        private String secret;

        @NotNull
        private String baseUrl;

        @NotNull
        private Duration httpReadTimeout;

        @NotNull
        private Duration httpRequestTimeout;

        @NotNull
        private ProfileType profileType;
    }

}
