package ru.yandex.travel.orders.workflows.orderitem.expedia;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.expedia.ExpediaClient;
import ru.yandex.travel.orders.entities.ExpediaOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.hotels.expedia.proto.EExpediaItemState;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.CancellingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.ConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.ConfirmingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.PollingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.RefundingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.ReservedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.expedia.handlers.ReservingStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class ExpediaWorkflowConfiguration {
    protected final ExpediaProperties expediaProperties;
    private final ExpediaClient expediaClient;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final BillingPartnerService billingPartnerService;
    private final Meters meters;
    private final ExpediaFiscalItemCreator expediaFiscalItemCreator;

    @Bean
    public WorkflowEventHandler<ExpediaOrderItem> expediaWorkflowEventHandler() {
        ImmutableMap.Builder<EExpediaItemState, StatefulWorkflowEventHandler<EExpediaItemState, ExpediaOrderItem>> builder = ImmutableMap.builder();
        builder
                .put(EExpediaItemState.IS_NEW, new NewStateHandler(billingPartnerService))
                .put(EExpediaItemState.IS_RESERVING, new ReservingStateHandler(expediaClient, expediaProperties,
                        meters, expediaFiscalItemCreator))
                .put(EExpediaItemState.IS_RESERVED, new ReservedStateHandler(meters))
                .put(EExpediaItemState.IS_CANCELLING, new CancellingStateHandler(expediaClient, expediaProperties,
                        meters))
                .put(EExpediaItemState.IS_CANCELLED, new CancelledStateHandler())
                .put(EExpediaItemState.IS_CONFIRMING, new ConfirmingStateHandler(expediaClient, expediaProperties,
                        meters))
                .put(EExpediaItemState.IS_POLLING_FOR_ITINERARY, new PollingStateHandler(expediaClient,
                        expediaProperties, meters))
                .put(EExpediaItemState.IS_CONFIRMED, new ConfirmedStateHandler(expediaClient, expediaProperties,
                        meters))
                .put(EExpediaItemState.IS_REFUNDING, new RefundingStateHandler(expediaClient, expediaProperties,
                        meters));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
