package ru.yandex.travel.orders.workflows.orderitem.expedia.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.expedia.ExpediaClient;
import ru.yandex.travel.orders.entities.ExpediaOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.expedia.proto.EExpediaItemState;
import ru.yandex.travel.orders.workflow.hotels.expedia.proto.TRefundCommit;
import ru.yandex.travel.orders.workflow.hotels.proto.TRefundStart;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.orders.workflow.plus.proto.TPlusPointsTopupCompleted;
import ru.yandex.travel.orders.workflow.plus.proto.TPlusPointsTopupCompletedWithError;
import ru.yandex.travel.orders.workflows.orderitem.expedia.ExpediaProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@IgnoreEvents(types = {TMoneyAcquired.class})
public class ConfirmedStateHandler extends BaseExpediaHandler {
    public ConfirmedStateHandler(ExpediaClient expediaClient, ExpediaProperties expediaProperties, Meters meters) {
        super(expediaClient, expediaProperties, meters);
    }

    @HandleEvent(TRefundStart.class)
    public void scheduleRefund(TRefundStart message, StateContext<EExpediaItemState, ExpediaOrderItem> context) {
        context.setState(EExpediaItemState.IS_REFUNDING);
        context.scheduleEvent(TRefundCommit.newBuilder()
                .setToken(message.getToken())
                .setForce(message.getForce())
                .setReason(message.getReason())
                .setSkipFinEvents(message.getSkipFinEvents())
                .setMoneyRefundMode(message.getMoneyRefundMode())
                .setRefundDescription(message.getRefundDescription())
                .build());
        log.info("scheduled refund");
    }

    @HandleEvent
    public void handlePlusPointsTopupCompleted(TPlusPointsTopupCompleted message,
                                               StateContext<EExpediaItemState, ExpediaOrderItem> context) {
        log.info("Plus points top-up completed");
    }

    @HandleEvent
    public void handlePlusPointsTopupCompleted(TPlusPointsTopupCompletedWithError message,
                                               StateContext<EExpediaItemState, ExpediaOrderItem> context) {
        log.info("Plus points top-up failed");
    }
}
