package ru.yandex.travel.orders.workflows.orderitem.expedia.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.ExpediaOrderItem;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.hotels.expedia.proto.EExpediaItemState;
import ru.yandex.travel.orders.workflow.hotels.expedia.proto.TReservationCommit;
import ru.yandex.travel.orders.workflow.hotels.proto.TReservationStart;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@RequiredArgsConstructor
@Slf4j
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<EExpediaItemState, ExpediaOrderItem> {
    private final BillingPartnerService billingPartnerService;

    @HandleEvent
    public void handleRegister(TReservationStart message, StateContext<EExpediaItemState, ExpediaOrderItem> context) {
        handleGenericRegister(null, context);
    }

    @HandleEvent
    public void handleGenericRegister(ru.yandex.travel.orders.workflow.orderitem.generic.proto.TReservationStart message,
                                      StateContext<EExpediaItemState, ExpediaOrderItem> context) {
        billingPartnerService.addAgreementOrThrow(context.getWorkflowEntity());
        context.setState(EExpediaItemState.IS_RESERVING);
        context.scheduleEvent(TReservationCommit.newBuilder().build());
        log.info("scheduled reservation");
    }
}
