package ru.yandex.travel.orders.workflows.orderitem.suburban;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.orders.configurations.AhcCommonProperties;
import ru.yandex.travel.suburban.partners.aeroexpress.AeroexpressClient;
import ru.yandex.travel.suburban.partners.aeroexpress.DefaultAeroexpressClient;
import ru.yandex.travel.suburban.partners.movista.DefaultMovistaClient;
import ru.yandex.travel.suburban.partners.movista.MovistaClient;
import ru.yandex.travel.train.partners.im.ImClient;
import ru.yandex.travel.train.partners.im.ImClientConfigurationHelper;
import ru.yandex.travel.train.partners.im.ImProperties;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(SuburbanProperties.class)
public class SuburbanConfiguration {
    private final SuburbanProperties props;
    private final AhcCommonProperties ahcCommonProperties;

    @Bean
    public MovistaClient movistaClient(
            @Qualifier("movistaAhcClientWrapper") AsyncHttpClientWrapper clientWrapper) {
        return new DefaultMovistaClient(clientWrapper, props.getProviders().getMovista().getClient());
    }

    @Bean("imSuburbanClient")
    public ImClient imSuburbanClient(
            @Qualifier("imSuburbanAhcClientWrapper") AsyncHttpClientWrapper clientWrapper) {
        ImProperties imProps = props.getProviders().getIm().getClient();

        return ImClientConfigurationHelper.createImClient(imProps, clientWrapper, null);
    }

    @Bean
    public AeroexpressClient aeroexpressClient(
            @Qualifier("aeroexpressAhcClientWrapper") AsyncHttpClientWrapper clientWrapper) {
        return new DefaultAeroexpressClient(clientWrapper, props.getProviders().getAeroexpress().getClient());
    }
}
