package ru.yandex.travel.orders.workflows.orderitem.suburban;

import java.math.BigDecimal;
import java.time.Duration;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.suburban.partners.aeroexpress.DefaultAeroexpressClient;
import ru.yandex.travel.suburban.partners.movista.DefaultMovistaClient;
import ru.yandex.travel.train.partners.im.ImProperties;

@ConfigurationProperties(value = "suburban", ignoreUnknownFields = false)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class SuburbanProperties {
    @NotNull
    private Providers providers;

    @NotNull
    private Tasks tasks;

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Providers {
        @Valid
        private MovistaProps movista;

        @Valid
        private ImProps im;

        @Valid
        private AeroexpressProps aeroexpress;
    }

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MovistaProps {
        @Valid
        private ProviderProps common;

        @Valid
        private DefaultMovistaClient.Config client;
    }

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ImProps {
        @Valid
        private ProviderProps common;

        @Valid
        ImProperties client;

        @NotNull
        private Duration downloadBlankTimeout;

        @NotNull
        private Duration getTicketBarcodeTimeout;

        @NotNull
        private Integer getTicketBarcodeMaxAttempts;

        @NotNull
        private Duration getTicketBarcodeRetryingTime;

        @NotNull
        private String fakePassengerEmail;
    }

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AeroexpressProps {
        @Valid
        private ProviderProps common;

        @Valid
        private DefaultAeroexpressClient.Config client;

        @NotNull
        private Duration orderExpireTimeout;
    }

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ProviderProps {
        @NotNull
        private Long billingClientId;

        @NotNull
        private Integer bookMaxAttempts;

        @NotNull
        private Integer confirmMaxAttempts;

        @NotNull
        private Duration confirmRetryingTime;

        @Valid
        private FiscalInfo fiscalInfo;

        @NotNull
        private MailProperties mail;

        @NotNull
        private FinancialEventsProps financialEvents;

        @Nullable
        private Duration paymentClearingDelay;
    }

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FiscalInfo {
        @NotNull
        private String inn;

        @NotNull
        private String title;
    }

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FinancialEventsProps {
        @NotNull
        @Min(0)
        @Max(1)
        private BigDecimal rewardFee;
        @NotNull
        @Min(0)
        @Max(1)
        private BigDecimal rewardFeeRefund;
        @NotNull
        @Min(0)
        @Max(1)
        private BigDecimal vat;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    @Validated
    public static class MailProperties {
        @NotEmpty
        private String orderConfirmedCampaign;
        private Duration preparingAttachmentsTimeout;
    }

    @Valid
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Tasks {
        @NotNull
        private SuburbanProperties.Tasks.ExpiredItemsConf itemsExpiration;

        @Valid
        @Data
        public static class ExpiredItemsConf {
            @Min(1)
            @NotNull
            private Integer poolSize;

            @NotNull
            private Duration initialStartDelay;

            @NotNull
            private Duration scheduleRate;
        }
    }
}
