package ru.yandex.travel.orders.workflows.orderitem.suburban;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.services.finances.providers.SuburbanFinancialDataProvider;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.services.suburban.environment.SuburbanOrderItemEnvProvider;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflows.orderitem.suburban.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.suburban.handlers.CancellingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.suburban.handlers.ConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.suburban.handlers.ConfirmingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.suburban.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.suburban.handlers.ReservedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.suburban.handlers.ReservingStateHandler;
import ru.yandex.travel.utils.ClockService;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class SuburbanWorkflowConfiguration {
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final BillingPartnerService billingPartnerService;
    private final SuburbanOrderItemEnvProvider suburbanEnvProvider;

    @Bean
    public WorkflowEventHandler<SuburbanOrderItem> suburbanOrderItemWorkflowEventHandler() {
        ImmutableMap.Builder<EOrderItemState,
                StatefulWorkflowEventHandler<EOrderItemState, SuburbanOrderItem>> builder = ImmutableMap.builder();
        builder.put(EOrderItemState.IS_NEW, new NewStateHandler(billingPartnerService, suburbanEnvProvider))
                .put(EOrderItemState.IS_RESERVING, new ReservingStateHandler(suburbanEnvProvider))
                .put(EOrderItemState.IS_RESERVED, new ReservedStateHandler(suburbanEnvProvider))
                .put(EOrderItemState.IS_CONFIRMING, new ConfirmingStateHandler(suburbanEnvProvider))
                .put(EOrderItemState.IS_CONFIRMED, new ConfirmedStateHandler())
                .put(EOrderItemState.IS_CANCELLING, new CancellingStateHandler())
                .put(EOrderItemState.IS_CANCELLED, new CancelledStateHandler());
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }

    @Bean
    public SuburbanFinancialDataProvider financialDataProvider(ClockService clockService) {
        return new SuburbanFinancialDataProvider(clockService, suburbanEnvProvider);
    }
}
