package ru.yandex.travel.orders.workflows.orderitem.suburban.handlers;

import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.workflow.order.proto.TServiceCancelled;
import ru.yandex.travel.orders.workflow.order.proto.TServiceConfirmed;
import ru.yandex.travel.orders.workflow.order.proto.TServiceReserved;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.suburban.proto.TCancellationCommit;
import ru.yandex.travel.suburban.model.SuburbanReservation;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;


public class BaseHandler extends AnnotatedStatefulWorkflowEventHandler<EOrderItemState, SuburbanOrderItem> {
    protected void setItemReserved(StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        SuburbanOrderItem orderItem = ctx.getWorkflowEntity();
        ctx.setState(EOrderItemState.IS_RESERVED);
        ctx.scheduleExternalEvent(orderItem.getOrderWorkflowId(),
                TServiceReserved.newBuilder().setServiceId(orderItem.getId().toString()).build());
    }

    protected void setItemConfirmed(StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        SuburbanOrderItem orderItem = ctx.getWorkflowEntity();
        ctx.setState(EOrderItemState.IS_CONFIRMED);
        ctx.scheduleExternalEvent(orderItem.getOrderWorkflowId(),
                TServiceConfirmed.newBuilder().setServiceId(orderItem.getId().toString()).build());
    }

    protected void setItemCancelling(StateContext<EOrderItemState, SuburbanOrderItem> ctx, String errorMessage) {
        ctx.getWorkflowEntity().getPayload().setError(new SuburbanReservation.Error(errorMessage));
        ctx.setState(EOrderItemState.IS_CANCELLING);
        ctx.scheduleEvent(TCancellationCommit.getDefaultInstance());
    }

    protected void setItemCancelled(StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        SuburbanOrderItem orderItem = ctx.getWorkflowEntity();
        ctx.setState(EOrderItemState.IS_CANCELLED);
        ctx.scheduleExternalEvent(orderItem.getOrderWorkflowId(),
                TServiceCancelled.newBuilder().setServiceId(orderItem.getId().toString()).build());
    }
}
