package ru.yandex.travel.orders.workflows.orderitem.suburban.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TConfirmationStart;
import ru.yandex.travel.orders.workflow.orderitem.suburban.proto.TCancellationCommit;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TReservationExpired;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@RequiredArgsConstructor
@IgnoreEvents(types = {
        TReservationExpired.class,
        TConfirmationStart.class
})
public class CancellingStateHandler extends BaseHandler {

    @HandleEvent
    public void handleCancellationCommit(TCancellationCommit event,
                                         StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        setItemCancelled(ctx);
    }
}
