package ru.yandex.travel.orders.workflows.orderitem.suburban.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.services.suburban.environment.SuburbanOrderItemEnvProvider;
import ru.yandex.travel.orders.services.suburban.providers.SuburbanProviderBase;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TReservationStart;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class NewStateHandler extends BaseHandler {
    private final BillingPartnerService billingPartnerService;

    private final SuburbanOrderItemEnvProvider suburbanEnvProvider;

    @HandleEvent
    public void handleReservationStart(TReservationStart message,
                                       StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        SuburbanOrderItem orderItem = ctx.getWorkflowEntity();
        SuburbanProviderBase provider = suburbanEnvProvider.createEnv(orderItem).createSuburbanProvider();

        ctx.scheduleEvent(provider.getTBeforeReservationMessage());

        billingPartnerService.addAgreementOrThrow(orderItem);
        ctx.setState(EOrderItemState.IS_RESERVING);

        ctx.scheduleEvent(provider.getTReservationCommitMessage());
    }
}
