package ru.yandex.travel.orders.workflows.orderitem.suburban.handlers;

import java.time.Instant;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.SuburbanOrderItem;
import ru.yandex.travel.orders.services.suburban.environment.SuburbanOrderItemEnvProvider;
import ru.yandex.travel.orders.services.suburban.providers.SuburbanProviderBase;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TCancellationStart;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TConfirmationStart;
import ru.yandex.travel.orders.workflow.orderitem.suburban.proto.TReservationExpired;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;


@Slf4j
@RequiredArgsConstructor
public class ReservedStateHandler extends BaseHandler {
    private final SuburbanOrderItemEnvProvider suburbanEnvProvider;

    @HandleEvent
    public void handleConfirmationStart(TConfirmationStart event,
                                        StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        SuburbanOrderItem orderItem = ctx.getWorkflowEntity();
        SuburbanProviderBase provider = suburbanEnvProvider.createEnv(orderItem).createSuburbanProvider();

        orderItem.getPayload().getWorkflowData().setConfirmStartedAt(Instant.now());
        ctx.setState(EOrderItemState.IS_CONFIRMING);
        ctx.scheduleEvent(provider.getTConfirmationCommitMessage());
        log.info("SuburbanOrderItem: scheduled confirmation");
    }

    @HandleEvent
    public void handleCancellationStart(TCancellationStart event,
                                        StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        setItemCancelling(ctx, "Handle TCancellationStart event");
    }

    @HandleEvent
    public void handleReservationExpired(TReservationExpired event,
                                         StateContext<EOrderItemState, SuburbanOrderItem> ctx) {
        SuburbanOrderItem orderItem = ctx.getWorkflowEntity();
        setItemCancelling(ctx, String.format("Reservation is expired at %s", orderItem.getExpiresAt()));
    }
}
