package ru.yandex.travel.orders.workflows.orderitem.suburban.jobs;

import java.util.Collection;
import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import ru.yandex.travel.orders.workflows.orderitem.suburban.SuburbanProperties;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.AbstractTaskKeyProvider;
import ru.yandex.travel.task_processor.TaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(SuburbanProperties.class)
public class SuburbanTaskProcessorsConfiguration {
    private final SuburbanOrderItemExpiredService suburbanOrderItemExpiredService;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;

    private final SuburbanProperties suburbanProperties;

    @Bean
    public TaskProcessor<UUID> suburbanOrderItemCheckingExpirationProcessor() {

        TaskKeyProvider<UUID> taskKeyProvider = new AbstractTaskKeyProvider<>() {
            @Override
            public Collection<UUID> getPendingTaskKeys(int maxResultSize) {
                return suburbanOrderItemExpiredService.fetchExpiredOrderItems(getLockedTaskKeys(), maxResultSize);
            }

            @Override
            public long getPendingTasksCount() {
                return suburbanOrderItemExpiredService.countExpiredOrderItems(getLockedTaskKeys());
            }
        };
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setName("SuburbanExpirationChecking");
        transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionDefinition.setIsolationLevel(TransactionDefinition.ISOLATION_REPEATABLE_READ);
        TransactionDefinition txDefinition = new DefaultTransactionDefinition(transactionDefinition);

        var taskConf = suburbanProperties.getTasks().getItemsExpiration();

        return new TaskProcessor<>(taskKeyProvider, suburbanOrderItemExpiredService::startCancellation,
                forcedRollbackTxManagerWrapper, txDefinition,
                TaskProcessorProperties.builder().name("SuburbanExpirationChecking")
                        .daemonPoolThreads(true).gracefulPoolShutdown(true)
                        .poolSize(taskConf.getPoolSize())
                        .initialStartDelay(taskConf.getInitialStartDelay())
                        .scheduleRate(taskConf.getScheduleRate()).build());
    }
}
