package ru.yandex.travel.orders.workflows.orderitem.train;

import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.travel.orders.workflow.orderitem.train.proto.EErrorCode;
import ru.yandex.travel.train.model.ErrorCode;

public class TrainProtoMaps {
    private static Map<ErrorCode, EErrorCode> errorCodeMap = Map.of(
            ErrorCode.TRY_LATER, EErrorCode.EM_TRY_LATER,
            ErrorCode.TARIFF_ERROR, EErrorCode.EM_TARIFF_ERROR,
            ErrorCode.CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE, EErrorCode.EM_CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE,
            ErrorCode.INVALID_BONUS_CARD, EErrorCode.EM_INVALID_BONUS_CARD,
            ErrorCode.INVALID_DOCUMENT_NUMBER, EErrorCode.EM_INVALID_DOCUMENT_NUMBER,
            ErrorCode.NAME_REQUIRED_LATIN_LETTERS, EErrorCode.EM_NAME_REQUIRED_LATIN_LETTERS,
            ErrorCode.NO_PLACES, EErrorCode.EM_NO_PLACES,
            ErrorCode.TOO_LATE, EErrorCode.EM_TOO_LATE,
            ErrorCode.TOO_LATE_FOR_ORDER, EErrorCode.EM_TOO_LATE_FOR_ORDER,
            ErrorCode.UNKNOWN_PARTNER_ERROR, EErrorCode.EM_UNKNOWN_PARTNER_ERROR
    );

    private static Map<EErrorCode, ErrorCode> errorCodeMapReversed = errorCodeMap.entrySet()
            .stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

    public static ErrorCode getErrorCode(EErrorCode value) {
        if (value == EErrorCode.EM_UNKNOWN) {
            return null;
        }
        return errorCodeMapReversed.get(value);
    }

    public static EErrorCode getProtoErrorCode(ErrorCode value) {
        if (value == null) {
            return EErrorCode.EM_UNKNOWN;
        }
        return errorCodeMap.get(value);
    }
}
