package ru.yandex.travel.orders.workflows.orderitem.train;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.orders.commons.proto.EVat;

@ConfigurationProperties(value = "train-workflow", ignoreUnknownFields = false)
@Getter
@Setter
@Component
@Validated
public class TrainWorkflowProperties {
    @Deprecated
    private Duration checkConfirmationDelay;
    @Deprecated
    private int checkConfirmationMaxTries;
    @NotEmpty
    private List<Duration> checkConfirmationTryDelay;
    @NotNull
    private Duration checkConfirmationTaskInitialStartDelay;
    @NotNull
    private Duration checkConfirmationTaskPeriod;
    @Positive
    private int checkConfirmationTaskNumberOfItems;
    @NotNull
    private Duration checkExpirationTaskInitialStartDelay;
    @NotNull
    private Duration checkExpirationTaskPeriod;
    @Positive
    private int checkExpirationTaskNumberOfItems;
    @NotNull
    private boolean checkPassengerDiscountsEnabled;
    @NotNull
    private BillingProperties billing;
    @NotNull
    private Duration reservationRetryDelay;
    @Positive
    private int reservationMaxTries;
    @Positive
    private int insuranceCheckoutMaxTries;
    @NotNull
    private boolean insuranceEnabled;
    @Positive
    private int cancellationMaxTries;
    @NotNull
    private Duration updateOnTheFlyOrderInfoTimeout;
    @NotNull
    private Duration updateOnTheFlyUpdateBlanksTimeout;
    @NotNull
    private Duration downloadBlankTimeout;
    @NotNull
    private MailProperties mail;
    @NotNull
    private SmsProperties sms;
    @NotNull
    private RefundProperties refund;
    @NotNull
    private OfficeRefundProperties officeRefund;
    @NotNull
    private LimiterProperties reservationConcurrencyLimit;
    @NotNull
    private LimiterProperties updateOnTheFlyConcurrencyLimit;

    @Positive
    private int checkInsuranceRefundMaxTries;
    @NotNull
    private Duration checkInsuranceRefundDelay;
    @NotNull
    private Duration checkInsuranceRefundTaskInitialStartDelay;
    @NotNull
    private Duration checkInsuranceRefundTaskPeriod;
    @Positive
    private int checkInsuranceRefundTaskNumberOfItems;

    @Positive
    private int checkTicketRefundMaxTries;
    @NotNull
    private Duration checkTicketRefundDelay;
    @NotNull
    private Duration checkTicketRefundTaskInitialStartDelay;
    @NotNull
    private Duration checkTicketRefundTaskPeriod;
    @Positive
    private int checkTicketRefundTaskNumberOfItems;

    @NotNull
    private Long billingClientId;
    @NotNull
    private Long billingInsuranceClientId;
    @Positive
    private BigDecimal insuranceFeeCoefficient;
    @NotNull
    private boolean rebookingEnabled;
    @NotNull
    private Duration orderExpirationTime;

    @NotNull
    private PromoHotel2020Properties promoHotel2020;

    private boolean generatePersonalPromoCodes;
    private String promoActionForHotelsName;
    private String commonPromoCodeForHotels;

    private boolean separatePassengersReserving;

    public enum ConcurrencyLimitMode {
        FIXED, ADAPTIVE
    }

    @Getter
    @Setter
    @Validated
    public static class BillingProperties {
        @NotEmpty
        private String ticketFiscalTitle;
        @NotEmpty
        private String serviceFiscalTitle;
        @NotEmpty
        private String feeFiscalTitle;
        @NotNull
        private EVat feeVat;
        @NotEmpty
        private String insuranceFiscalTitle;
        @NotEmpty
        private String partnerInn;
    }

    @Getter
    @Setter
    @Validated
    public static class MailProperties {
        @NotEmpty
        private String orderConfirmedCampaign;
        @NotEmpty
        private String orderConfirmedGenericCampaign;
        @NotEmpty
        private String frontUrl;
        @NotNull
        private Duration preparingAttachmentsTime;
        @NotEmpty
        private String orderRefundCampaign;
        @NotEmpty
        private String orderRefundGenericCampaign;
    }

    @Getter
    @Setter
    @Validated
    public static class SmsProperties {
        @NotEmpty
        private String orderTicketText;
        @NotEmpty
        private String orderTicketsText;
    }

    @Getter
    @Setter
    @Validated
    public static class RefundProperties {
        @NotNull
        private Duration calculationExpireTime;
        @NotNull
        private Duration returnFeeTime;
    }

    @Getter
    @Setter
    @Validated
    public static class OfficeRefundProperties {

        boolean enabled;

        @NotNull
        private Duration checkTaskInitialStartDelay;
        @NotNull
        private Duration checkTaskPeriod;
        @Positive
        private int daysToCheck;
        @NotNull
        private Duration refundDelay;
        @NotNull
        private Duration refundExtraDelay;
        @NotNull
        private Duration retryDelay;
    }

    @Getter
    @Setter
    @Validated
    public static class PromoHotel2020Properties {
        boolean enabled;
        @NotNull
        private Duration delay;
        @NotEmpty
        private String campaign;
    }

    @Getter
    @Setter
    @Validated
    public static class LimiterProperties {
        private ConcurrencyLimitMode mode;

        private ConcurrencyLimitFixedProperties fixed;

        private ConcurrencyLimitAdaptiveProperties adaptive;
    }

    @Getter
    @Setter
    @Validated
    public static class ConcurrencyLimitFixedProperties {
        @Positive
        private int limit;
    }

    @Getter
    @Setter
    @Validated
    public static class ConcurrencyLimitAdaptiveProperties {
        @NotNull
        private Duration maxTimeout;

        @Positive
        private int minConcurrentCalls;

        @Positive
        private int maxConcurrentCalls;
    }
}
