package ru.yandex.travel.orders.workflows.orderitem.train.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TReservationExpired;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@RequiredArgsConstructor
@IgnoreEvents(types = {
        ru.yandex.travel.orders.workflow.orderitem.generic.proto.TCancellationStart.class,
        ru.yandex.travel.orders.workflow.orderitem.train.proto.TCancellationStart.class,
        ru.yandex.travel.orders.workflow.orderitem.generic.proto.TConfirmationStart.class,
        ru.yandex.travel.orders.workflow.orderitem.train.proto.TConfirmationStart.class,
        TReservationExpired.class
})
public class CancelledStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<EOrderItemState, TrainOrderItem> {
}
