package ru.yandex.travel.orders.workflows.orderitem.train.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.services.train.ImClientProvider;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TOfficeRefundOccured;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TPartnerInfoUpdated;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TUpdateTickets;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class RefundedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EOrderItemState, TrainOrderItem> {
    private final ImClientProvider imClientProvider;

    @HandleEvent
    public void handlePartnerInfoUpdated(TPartnerInfoUpdated event,
                                         StateContext<EOrderItemState, TrainOrderItem> ctx) {
        ConfirmedStateHandler.handlePartnerInfoUpdated(event, ctx);
    }

    @HandleEvent
    public void handleUpdateTickets(TUpdateTickets event, StateContext<EOrderItemState, TrainOrderItem> ctx) {
        ConfirmedStateHandler.handleUpdateTickets(imClientProvider, event, ctx);
    }

    @HandleEvent
    public void handleOfficeRefund(TOfficeRefundOccured event, StateContext<EOrderItemState, TrainOrderItem> ctx) {
        ctx.getWorkflowEntity().setState(EOrderItemState.IS_CONFIRMED);
        ctx.scheduleEvent(event);
    }
}
