package ru.yandex.travel.orders.workflows.orderitem.train.handlers;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TCancellationCommit;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TConfirmationCommit;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TInsuranceReservationCommit;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TInsuranceReservationStart;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TReservationExpired;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class ReservedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EOrderItemState, TrainOrderItem> {

    @HandleEvent
    public void handleConfirmationStart(ru.yandex.travel.orders.workflow.orderitem.generic.proto.TConfirmationStart event,
                                        StateContext<EOrderItemState, TrainOrderItem> ctx) {
        confirmationStart(ctx);
    }

    @HandleEvent
    public void handleConfirmationStart(ru.yandex.travel.orders.workflow.orderitem.train.proto.TConfirmationStart event,
                                        StateContext<EOrderItemState, TrainOrderItem> ctx) {
        confirmationStart(ctx);
    }

    private void confirmationStart(StateContext<EOrderItemState, TrainOrderItem> ctx) {
        TrainOrderItem orderItem = ctx.getWorkflowEntity();
        if (orderItem.getPayload().isSlaveItem()) {
            ctx.setState(EOrderItemState.IS_CHECKING_CONFIRMATION_TRAINS);
            return;
        }
        ctx.setState(EOrderItemState.IS_CONFIRMING);
        ctx.scheduleEvent(TConfirmationCommit.newBuilder().setDeduplicationKey(UUID.randomUUID().toString()).build());
        log.info("TrainOrderItem '{}': scheduled confirmation", ctx.getWorkflowEntity().getId());
    }

    @HandleEvent
    public void handleInsuranceReservationStart(TInsuranceReservationStart event,
                                                StateContext<EOrderItemState, TrainOrderItem> ctx) {
        ctx.setState(EOrderItemState.IS_RESERVING_INSURANCE);
        ctx.scheduleEvent(TInsuranceReservationCommit.newBuilder().build());
    }

    @HandleEvent
    public void handleReservationExpired(TReservationExpired event,
                                         StateContext<EOrderItemState, TrainOrderItem> ctx) {
        ctx.setState(EOrderItemState.IS_CANCELLING);
        ctx.scheduleEvent(TCancellationCommit.newBuilder().build());
    }

    @Deprecated
    @HandleEvent
    public void handleCancellationStart(ru.yandex.travel.orders.workflow.orderitem.train.proto.TCancellationStart event,
                                        StateContext<EOrderItemState, TrainOrderItem> ctx) {
        cancellationStart(ctx);
    }

    @HandleEvent
    public void handleCancellationStart(ru.yandex.travel.orders.workflow.orderitem.generic.proto.TCancellationStart event,
                                        StateContext<EOrderItemState, TrainOrderItem> ctx) {
        cancellationStart(ctx);
    }

    private void cancellationStart(StateContext<EOrderItemState, TrainOrderItem> ctx) {
        ctx.setState(EOrderItemState.IS_CANCELLING);
        ctx.scheduleEvent(TCancellationCommit.newBuilder().build());
    }
}
