package ru.yandex.travel.orders.workflows.orderitem.train.insurancerefund;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.TrainInsuranceRefund;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.services.train.ImClientProvider;
import ru.yandex.travel.orders.workflow.orderitem.train.insurancerefund.proto.ETrainInsuranceRefundState;
import ru.yandex.travel.orders.workflows.orderitem.train.insurancerefund.handlers.CheckingRefundStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.train.insurancerefund.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.train.insurancerefund.handlers.RefundingStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class InsuranceRefundWorkflowConfiguration {
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final ImClientProvider imClientProvider;
    private final StarTrekService starTrekService;

    @Bean
    public WorkflowEventHandler<TrainInsuranceRefund> trainInsuranceRefundWorkflowEventHandler() {
        ImmutableMap.Builder<ETrainInsuranceRefundState, StatefulWorkflowEventHandler<ETrainInsuranceRefundState, TrainInsuranceRefund>> builder = ImmutableMap.builder();
        builder
            .put(ETrainInsuranceRefundState.RS_NEW, new NewStateHandler())
            .put(ETrainInsuranceRefundState.RS_REFUNDING, new RefundingStateHandler(imClientProvider))
            .put(ETrainInsuranceRefundState.RS_CHECKING_REFUND, new CheckingRefundStateHandler(starTrekService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
