package ru.yandex.travel.orders.workflows.orderitem.train.insurancerefund.handlers;


import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainInsuranceRefund;
import ru.yandex.travel.orders.workflow.orderitem.train.insurancerefund.proto.ETrainInsuranceRefundState;
import ru.yandex.travel.orders.workflow.orderitem.train.insurancerefund.proto.TRefundOne;
import ru.yandex.travel.orders.workflow.orderitem.train.insurancerefund.proto.TStartRefund;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class NewStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<ETrainInsuranceRefundState, TrainInsuranceRefund> {

    @HandleEvent
    public void handleStartRefund(TStartRefund message,
                               StateContext<ETrainInsuranceRefundState, TrainInsuranceRefund> context) {
        context.setState(ETrainInsuranceRefundState.RS_REFUNDING);
        context.scheduleEvent(TRefundOne.newBuilder().build());
    }
}
