package ru.yandex.travel.orders.workflows.orderitem.train.ticketrefund;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.TrainTicketRefund;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.services.train.ImClientProvider;
import ru.yandex.travel.orders.workflow.orderitem.train.ticketrefund.proto.ETrainTicketRefundState;
import ru.yandex.travel.orders.workflows.orderitem.train.ticketrefund.handlers.CheckingRefundStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.train.ticketrefund.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.train.ticketrefund.handlers.RefundingStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class TicketRefundWorkflowConfiguration {
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final ImClientProvider imClientProvider;
    private final StarTrekService starTrekService;

    @Bean
    public WorkflowEventHandler<TrainTicketRefund> trainTicketRefundWorkflowEventHandler() {
        ImmutableMap.Builder<ETrainTicketRefundState, StatefulWorkflowEventHandler<ETrainTicketRefundState, TrainTicketRefund>> builder = ImmutableMap.builder();
        builder
            .put(ETrainTicketRefundState.RS_NEW, new NewStateHandler())
            .put(ETrainTicketRefundState.RS_REFUNDING, new RefundingStateHandler(imClientProvider))
            .put(ETrainTicketRefundState.RS_CHECKING_REFUND, new CheckingRefundStateHandler(starTrekService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
