package ru.yandex.travel.orders.workflows.orderitem.train.ticketrefund.handlers;


import java.util.Set;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.entities.TrainTicketRefund;
import ru.yandex.travel.orders.workflow.orderitem.train.ticketrefund.proto.ETrainTicketRefundState;
import ru.yandex.travel.orders.workflow.orderitem.train.ticketrefund.proto.TRefundAll;
import ru.yandex.travel.orders.workflow.orderitem.train.ticketrefund.proto.TRefundOne;
import ru.yandex.travel.orders.workflow.orderitem.train.ticketrefund.proto.TStartRefund;
import ru.yandex.travel.train.model.refund.PassengerRefundInfo;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class NewStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<ETrainTicketRefundState, TrainTicketRefund> {
    private static int FINLAND_ID = 123;

    @HandleEvent
    public void handleStartRefund(TStartRefund message,
                               StateContext<ETrainTicketRefundState, TrainTicketRefund> context) {
        context.setState(ETrainTicketRefundState.RS_REFUNDING);
        if (refundTicketsByOne(context.getWorkflowEntity())) {
            context.scheduleEvent(TRefundOne.newBuilder().build());
        } else {
            context.scheduleEvent(TRefundAll.newBuilder().build());
        }
    }

    private boolean refundTicketsByOne(TrainTicketRefund refund) {
        TrainOrderItem orderItem = refund.getOrderItem();
        // Для обратного выезда из Финляндии возврат доступен только отдельно по каждому билету
        if (orderItem.getPayload().getCountryFromId() == FINLAND_ID)
            return true;
        if (refund.getPayload().getBuyOperationIds().size() != 1) {
            return true;
        }
        Set<Integer> orderBlanks = orderItem.getPayload().getPassengers().stream().map(x -> x.getTicket().getBlankId())
                .collect(Collectors.toSet());
        Set<Integer> refundBlanks = refund.getPayload().getItems().stream().map(PassengerRefundInfo::getBlankId)
                .collect(Collectors.toSet());
        return !orderBlanks.equals(refundBlanks);
    }
}
