package ru.yandex.travel.orders.workflows.orderitem.travelline;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.travelline.DefaultTravellineClient;
import ru.yandex.travel.hotels.common.partners.travelline.TravellineClient;
import ru.yandex.travel.hotels.common.partners.travelline.WrappedTravellineClient;

@Configuration
@EnableConfigurationProperties(TravellineConfigurationProperties.class)
public class TravellineConfiguration {
    @Bean
    public TravellineClient travellineClient(@Qualifier("travellineAhcClientWrapper") AsyncHttpClientWrapper travellineClientWrapper,
                                             TravellineConfigurationProperties properties,
                                             Retry retryHelper) {
        var defaultClient = new DefaultTravellineClient(travellineClientWrapper, properties.getClient(), retryHelper);
        if (properties.isEnableTestNames()) {
            return new WrappedTravellineClient(defaultClient);
        } else {
            return defaultClient;
        }
    }
}
