package ru.yandex.travel.orders.workflows.orderitem.travelline;

import java.time.Duration;
import java.time.Instant;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.travelline.TravellineClientProperties;

@ConfigurationProperties(value = "travelline", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class TravellineConfigurationProperties {
    @NotNull
    @Valid
    private TravellineClientProperties client;

    @NotNull
    private Duration reservationDuration;

    @NotNull
    @Valid
    private BillingProperties billing;

    private boolean enableTestNames;

    @Getter
    @Setter
    @Validated
    public static class BillingProperties {
        @NotEmpty
        private String fiscalTitle;

        @NotEmpty
        private String mealFiscalTitle;

        private boolean generateMealItems;
    }

    @NotNull
    private Instant enableMakeExtraPaymentSince;

    @NotNull
    private Duration concurrentModificationRetryIn;
}
