package ru.yandex.travel.orders.workflows.orderitem.travelline;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.hotels.common.partners.travelline.model.VatTaxType;
import ru.yandex.travel.orders.entities.FiscalItem;
import ru.yandex.travel.orders.entities.FiscalItemType;
import ru.yandex.travel.orders.entities.TravellineOrderItem;
import ru.yandex.travel.orders.entities.VatType;
import ru.yandex.travel.orders.workflows.orderitem.hotel.AbstractHotelFiscalItemCreator;

@RequiredArgsConstructor
@Service
@Slf4j
public class TravellineFiscalItemCreator extends AbstractHotelFiscalItemCreator<TravellineOrderItem> {

    private final TravellineConfigurationProperties properties;

    @Override
    protected void addProviderSpecificPropertiesToMainFiscalItem(FiscalItem item, TravellineOrderItem orderItem) {
        //TODO(tivelkov): change type to travelline
        item.setType(FiscalItemType.EXPEDIA_HOTEL);
        item.setTitle(properties.getBilling().getFiscalTitle());
        if (orderItem.getItinerary().getVatTaxOverride() != null) {
            final VatType mapped = mapTLVatType(orderItem.getItinerary().getVatTaxOverride());
            if (mapped != orderItem.getAgreement().getVatType()) {
                log.warn("Rate-plan based VAT override ({}) differs from the one passed in agreement ({}). " +
                        "Using override", mapped, orderItem.getAgreement().getVatType());
            } else {
                log.info("Rate-plan based VAT override matches the one passed in agreement ({})", mapped);
            }
            item.setVatType(mapped);
        } else {
            log.info("No VAT override provided. Using the base from agreement ({})",
                    orderItem.getAgreement().getVatType());
            item.setVatType(orderItem.getAgreement().getVatType());
        }
        item.setInn(orderItem.getAgreement().getInn());
    }

    private VatType mapTLVatType(VatTaxType tlVatType) {
        switch (tlVatType) {
            case NONE:
                return VatType.VAT_NONE;
            case VAT0:
                return VatType.VAT_0;
            case VAT10:
                return VatType.VAT_10;
            case VAT18:
                return VatType.VAT_18;
            case VAT110:
                return VatType.VAT_10_110;
            case VAT118:
                return VatType.VAT_18_118;
            case VAT120:
                return VatType.VAT_20_120;
            case VAT20:
                return VatType.VAT_20;
            default:
                return null;
        }
    }

    @Override
    protected void addProviderSpecificPropertiesToMealFiscalItem(FiscalItem fiscalItem, TravellineOrderItem orderItem) {
        fiscalItem.setTitle(properties.getBilling().getMealFiscalTitle());
    }
}
