package ru.yandex.travel.orders.workflows.orderitem.travelline;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.travelline.TravellineClient;
import ru.yandex.travel.orders.cache.BalanceContractDictionary;
import ru.yandex.travel.orders.entities.TravellineOrderItem;
import ru.yandex.travel.orders.services.finances.FinancialEventService;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.hotels.travelline.proto.ETravellineItemState;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.CancellingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.ConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.ConfirmingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.RefundingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.ReservedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.travelline.handlers.ReservingStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class TravellineWorkflowConfiguration {
    private final TravellineClient travellineClient;
    private final TravellineConfigurationProperties properties;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final BillingPartnerService billingPartnerService;
    private final BalanceContractDictionary balanceContractDictionary;
    private final FinancialEventService financialEventService;
    private final Meters meters;
    private final TravellineFiscalItemCreator fiscalItemCreator;

    @Bean
    public WorkflowEventHandler<TravellineOrderItem> travellineOrderItemWorkflowEventHandler() {
        ImmutableMap.Builder<ETravellineItemState, StatefulWorkflowEventHandler<ETravellineItemState,
                TravellineOrderItem>> builder = ImmutableMap.builder();
        builder
                .put(ETravellineItemState.IS_NEW, new NewStateHandler(meters, billingPartnerService))
                .put(ETravellineItemState.IS_RESERVING, new ReservingStateHandler(travellineClient, properties, meters,
                        fiscalItemCreator))
                .put(ETravellineItemState.IS_RESERVED, new ReservedStateHandler(meters))
                .put(ETravellineItemState.IS_CANCELLING, new CancellingStateHandler(travellineClient, meters))
                .put(ETravellineItemState.IS_CANCELLED, new CancelledStateHandler(meters))
                .put(ETravellineItemState.IS_CONFIRMING, new ConfirmingStateHandler(travellineClient, meters, properties))
                .put(ETravellineItemState.IS_CONFIRMED, new ConfirmedStateHandler(meters,
                        financialEventService, billingPartnerService, properties, travellineClient))
                .put(ETravellineItemState.IS_REFUNDING, new RefundingStateHandler(travellineClient, meters));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
