package ru.yandex.travel.orders.workflows.orderitem.travelline.handlers;

import java.util.function.Supplier;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.base.exceptions.PartnerException;
import ru.yandex.travel.hotels.common.partners.base.exceptions.RetryableHttpException;
import ru.yandex.travel.hotels.common.partners.base.exceptions.RetryableIOException;
import ru.yandex.travel.hotels.common.partners.travelline.exceptions.ReturnedErrorException;
import ru.yandex.travel.hotels.common.partners.travelline.model.ErrorType;
import ru.yandex.travel.hotels.proto.THotelTestContext;
import ru.yandex.travel.orders.entities.TravellineOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.travelline.proto.ETravellineItemState;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.exceptions.RetryableException;

@Slf4j
public class BaseTravellineHandler extends AnnotatedStatefulWorkflowEventHandler<ETravellineItemState,
        TravellineOrderItem> {

    protected final Meters meters;

    public BaseTravellineHandler(Meters meters) {
        this.meters = meters;
    }

    protected CallContext getCallContext(TravellineOrderItem orderItem, CallContext.CallPhase phase) {
        THotelTestContext testContext = null;
        if (orderItem.getTestContext() != null && orderItem.getTestContext() instanceof THotelTestContext) {
            testContext = (THotelTestContext) orderItem.getTestContext();
        }
        return new CallContext(phase, testContext, null, null, orderItem.getHotelItinerary(), null);
    }

    protected <T> T wrap(Supplier<T> supplier, boolean needToRetryOnUnableToProcess) {
        try {
            return supplier.get();
        } catch (ReturnedErrorException exception) {
            if (exception.getErrorOfType(ErrorType.SOLD_OUT) != null) {
                throw exception;
            }
            if (needToRetryOnUnableToProcess && exception.getErrorOfType(ErrorType.UNABLE_TO_PROCESS) != null) {
                throw new RetryableException(exception);
            } else {
                throw exception;
            }
        } catch (PartnerException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof RetryableHttpException) {
                throw new RetryableException(cause);
            } else if (cause instanceof RetryableIOException) {
                throw new RetryableException(cause);
            } else {
                throw exception;
            }
        }
    }
}
