package ru.yandex.travel.orders.workflows.payments.invoice;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.services.payments.InvoiceFactory;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflows.payments.invoice.handlers.CancellationInProgressStateHandler;
import ru.yandex.travel.orders.workflows.payments.invoice.handlers.CancellationRetryPostponedStateHandler;
import ru.yandex.travel.orders.workflows.payments.invoice.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.payments.invoice.handlers.DraftStateHandler;
import ru.yandex.travel.orders.workflows.payments.invoice.handlers.FullyPaidStateHandler;
import ru.yandex.travel.orders.workflows.payments.invoice.handlers.InvoicePendingStateHandler;
import ru.yandex.travel.orders.workflows.payments.invoice.handlers.PaymentInProgressStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class PendingInvoiceWorkflowConfiguration {
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final InvoiceFactory invoiceFactory;

    @Bean
    public WorkflowEventHandler<PendingInvoice> pendingInvoiceWorkflowEventHandler() {
        ImmutableMap.Builder<EPaymentState,
                StatefulWorkflowEventHandler<EPaymentState, PendingInvoice>> builder = ImmutableMap.builder();
        builder.put(EPaymentState.PS_DRAFT, new DraftStateHandler())
                .put(EPaymentState.PS_INVOICE_PENDING, new InvoicePendingStateHandler(invoiceFactory))
                .put(EPaymentState.PS_PAYMENT_IN_PROGRESS, new PaymentInProgressStateHandler())
                .put(EPaymentState.PS_FULLY_PAID, new FullyPaidStateHandler())
                .put(EPaymentState.PS_CANCELLATION_IN_PROGRESS, new CancellationInProgressStateHandler())
                .put(EPaymentState.PS_CANCELLATION_RETRY_POSTPONED, new CancellationRetryPostponedStateHandler())
                .put(EPaymentState.PS_CANCELLED, new CancelledStateHandler());

        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
