package ru.yandex.travel.orders.workflows.payments.invoice.handlers;

import java.time.Instant;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.workflow.order.proto.TClearingInProcess;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceRefunded;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquireErrorOccurred;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCancelled;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class CancellationInProgressStateHandler extends BasePendingInvoiceHandler {

    @HandleEvent
    public void handleMoneyAcquired(TMoneyAcquired event, StateContext<EPaymentState, PendingInvoice> ctx) {
        fullyRefundPaidAttempt(ctx);
    }

    @HandleEvent
    public void handleInvoiceRefunded(TInvoiceRefunded event, StateContext<EPaymentState, PendingInvoice> ctx) {
        ctx.setState(EPaymentState.PS_CANCELLED);
        ctx.getWorkflowEntity().setClosedAt(Instant.now());
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerWorkflowId(), TPaymentCancelled.newBuilder().build());
    }

    @HandleEvent
    public void handleMoneyAcquireErrorOccurred(TMoneyAcquireErrorOccurred event, StateContext<EPaymentState,
            PendingInvoice> ctx) {
        ctx.setState(EPaymentState.PS_CANCELLED);
        ctx.getWorkflowEntity().setClosedAt(Instant.now());
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerWorkflowId(), TPaymentCancelled.newBuilder().build());
    }

    @Override
    @HandleEvent
    public void handle(TClearingInProcess message, StateContext<EPaymentState, PendingInvoice> ctx) {
        super.handle(message, ctx);
        log.info("Unable to refund the payment of an invoice being cancelled since it is being cleared; postponing the refund");
        ctx.setState(EPaymentState.PS_CANCELLATION_RETRY_POSTPONED);
    }
}
