package ru.yandex.travel.orders.workflows.payments.invoice.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceCleared;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class CancellationRetryPostponedStateHandler extends BasePendingInvoiceHandler {
    @Override
    @HandleEvent
    public void handle(TInvoiceCleared message, StateContext<EPaymentState, PendingInvoice> ctx) {
        super.handle(message, ctx);
        log.info("Payment of the cancelled invoice has been cleared, re-starting its refund");
        fullyRefundPaidAttempt(ctx);
        ctx.setState(EPaymentState.PS_CANCELLATION_IN_PROGRESS);
    }
}
