package ru.yandex.travel.orders.workflows.payments.invoice.handlers;

import java.time.Instant;

import ru.yandex.travel.orders.entities.PendingInvoice;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCancelled;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.orders.workflow.payments.proto.TCancelPayment;
import ru.yandex.travel.orders.workflow.payments.proto.TPublish;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

public class DraftStateHandler extends BasePendingInvoiceHandler {
    @HandleEvent
    public void handlePublish(TPublish message, StateContext<EPaymentState, PendingInvoice> ctx) {
        ctx.setState(EPaymentState.PS_INVOICE_PENDING);
    }

    @HandleEvent
    public void handleCancelPayment(TCancelPayment message, StateContext<EPaymentState, PendingInvoice> ctx) {
        ctx.setState(EPaymentState.PS_CANCELLED);
        ctx.getWorkflowEntity().setClosedAt(Instant.now());
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOwnerWorkflowId(), TPaymentCancelled.newBuilder().build());
    }
}
